package org.eclipse.jem.tests.beaninfo.javax.swing;
/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

import java.beans.*;

import org.eclipse.jem.tests.beaninfo.preq.infos.BaseBeanInfo;

public class JLabelBeanInfo extends BaseBeanInfo {

/**
 * Gets the bean class.
 * @return java.lang.Class
 */
public Class getBeanClass() {
	return javax.swing.JLabel.class;
}
public java.beans.BeanDescriptor getBeanDescriptor() {
	java.beans.BeanDescriptor aDescriptor = null;
	/* Create and return the bean descriptor. */
	try {
		aDescriptor = createBeanDescriptor(getBeanClass(), new Object[] {
	               		DISPLAYNAME, "JLabel",
	        			SHORTDESCRIPTION, "Display area for static text and/or an image"
						}			    
				  	  );
		aDescriptor.setValue("ICON_COLOR_32x32", "icons/label32.gif");
		aDescriptor.setValue("ICON_COLOR_16x16", "icons/label16.gif");
	} catch (Throwable exception) {
		handleException(exception);
	};
	return aDescriptor;
}
/**
 * Return the event set descriptors for this bean.
 * @return java.beans.EventSetDescriptor[]
 */
public java.beans.EventSetDescriptor[] getEventSetDescriptors() {
	return( new EventSetDescriptor[0]);
}
/**
  * @return an icon of the specified kind for JButton
  */
public java.awt.Image getIcon(int kind) 
{
	if (kind == ICON_COLOR_32x32) 
	    return loadImage("label32.gif");
	if (kind == ICON_COLOR_16x16) 
	    return loadImage("label16.gif");
   	return super.getIcon(kind);
}
/**
 * Return the method descriptors for this bean.
 * @return java.beans.MethodDescriptor[]
 */
public java.beans.MethodDescriptor[] getMethodDescriptors() {
	try {
		MethodDescriptor aDescriptorList[] = {
		  	// getAccessibleContext()
			super.createMethodDescriptor(getBeanClass(),"getAccessibleContext", 
				new Object[] {
	   			DISPLAYNAME, "getAccessibleContext()",
	      		// SHORTDESCRIPTION, "Get the accessible context",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		  	// getDisabledIcon()
			super.createMethodDescriptor(getBeanClass(),"getDisabledIcon", 
				new Object[] {
	   			DISPLAYNAME, "getDisabledIcon()",
	      		// SHORTDESCRIPTION, "Get the disabled icon",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		  	// getDisplayedMnemonic()
			super.createMethodDescriptor(getBeanClass(),"getDisplayedMnemonic", 
				new Object[] {
	   			DISPLAYNAME, "getDisplayedMnemonic()",
	      		// SHORTDESCRIPTION, "Get the mnemonic for associated component",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		  	// getHorizontalAlignment()
			super.createMethodDescriptor(getBeanClass(),"getHorizontalAlignment", 
				new Object[] {
	   			DISPLAYNAME, "getHorizontalAlignment()",
	      		SHORTDESCRIPTION, "Get the horizontal alignment of icon and text",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		  	// getHorizontalTextPosition()
			super.createMethodDescriptor(getBeanClass(),"getHorizontalTextPosition", 
				new Object[] {
	   			DISPLAYNAME, "getHorizontalTextPosition()",
	      		SHORTDESCRIPTION, "Get the horizontal position of text relative to icon",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		  	// getIcon()
			super.createMethodDescriptor(getBeanClass(),"getIcon", 
				new Object[] {
	   			DISPLAYNAME, "getIcon()",
	      		// SHORTDESCRIPTION, "Get the icon image displayed",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		  	// getIconTextGap()
			super.createMethodDescriptor(getBeanClass(),"getIconTextGap", 
				new Object[] {
	   			DISPLAYNAME, "getIconTextGap()",
	   			EXPERT, Boolean.TRUE,
	      		// SHORTDESCRIPTION, "Get the space between icon and text",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		  	// getLabelFor()
			super.createMethodDescriptor(getBeanClass(),"getLabelFor", 
				new Object[] {
	   			DISPLAYNAME, "getLabelFor()",
	      		SHORTDESCRIPTION, "Get the component associated with the label",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		  	// getText()
			super.createMethodDescriptor(getBeanClass(),"getText", 
				new Object[] {
	   			DISPLAYNAME, "getText()",
	      		// SHORTDESCRIPTION, "Get the text",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		  	// getUI()
			super.createMethodDescriptor(getBeanClass(),"getUI", 
				new Object[] {
	   			DISPLAYNAME, "getUI()",
	      		// SHORTDESCRIPTION, "Get the LabelUI object",
	      		EXPERT, Boolean.TRUE,
	      		OBSCURE, Boolean.TRUE	      		
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		  	// getVerticalAlignment()
			super.createMethodDescriptor(getBeanClass(),"getVerticalAlignment", 
				new Object[] {
	   			DISPLAYNAME, "getVerticalAlignment()",
	      		SHORTDESCRIPTION, "Get the vertical alignment of icon and text",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		  	// getVerticalTextPosition()
			super.createMethodDescriptor(getBeanClass(),"getVerticalTextPosition", 
				new Object[] {
	   			DISPLAYNAME, "getVerticalTextPosition()",
	      		SHORTDESCRIPTION, "Get the vertical position of text relative to icon",
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	),
		  	// setDisabledIcon(Icon)
			super.createMethodDescriptor(getBeanClass(),"setDisabledIcon", 
				new Object[] {
	   			DISPLAYNAME, "setDisabledIcon(Icon)",
	      		// SHORTDESCRIPTION, "Set the icon for the disabled state",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("icon", new Object[] {
	   					DISPLAYNAME, "icon",
	      				// SHORTDESCRIPTION, "Disabled icon",
	      				})
	      		},
	      		new Class[] {
	      			javax.swing.Icon.class
	      		}		    		
		  	),
		  	// setDisplayedMnemonic(char)
			super.createMethodDescriptor(getBeanClass(),"setDisplayedMnemonic", 
				new Object[] {
	   			DISPLAYNAME, "setDisplayedMnemonic(char)",
	      		SHORTDESCRIPTION, "Set the mnemonic for associated component",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("mnemonic", new Object[] {
	   					DISPLAYNAME, "mnemonic",
	      				// SHORTDESCRIPTION, "Mnemonic key",
	      				})
	      		},
	      		new Class[] {
	      			char.class
	      		}		    		
		  	),
		  	// setFont(Font)
			super.createMethodDescriptor(getBeanClass(),"setFont", 
				new Object[] {
	   			DISPLAYNAME, "setFont(Font)",
	      		// SHORTDESCRIPTION, "Set the text font",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("font", new Object[] {
	   					DISPLAYNAME, "aFont",
	      				// SHORTDESCRIPTION, "Font for text",
	      				})
	      		},
	      		new Class[] {
	      			java.awt.Font.class
	      		}		    		
		  	),
		  	// setHorizontalAlignment(int)
			super.createMethodDescriptor(getBeanClass(),"setHorizontalAlignment", 
				new Object[] {
	   			DISPLAYNAME, "setHorizontalAlignment(int)",
	      		SHORTDESCRIPTION, "Set the horizontal alignment of icon and text",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("alignment", new Object[] {
	   					DISPLAYNAME, "alignment",
	      				// SHORTDESCRIPTION, "CENTER, LEFT or RIGHT",
	      				})
	      		},
	      		new Class[] {
	      			int.class
	      		}		    		
		  	),
		  	// setHorizontalTextPosition(int)
			super.createMethodDescriptor(getBeanClass(),"setHorizontalTextPosition", 
				new Object[] {
	   			DISPLAYNAME, "setHorizontalTextPosition(int)",
	      		SHORTDESCRIPTION, "Set the horizontal text position relative to the icon",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("position", new Object[] {
	   					DISPLAYNAME, "textPosition",
	      				// SHORTDESCRIPTION, "CENTER, LEFT or RIGHT",
	      				})
	      		},
	      		new Class[] {
	      			int.class
	      		}		    		
		  	),
		  	// setIcon(Icon)
			super.createMethodDescriptor(getBeanClass(),"setIcon", 
				new Object[] {
	   			DISPLAYNAME, "setIcon(Icon)",
	      		// SHORTDESCRIPTION, "Set the icon to display",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("icon", new Object[] {
	   					DISPLAYNAME, "icon",
	      				// SHORTDESCRIPTION, "Image icon",
	      				})
	      		},
	      		new Class[] {
	      			javax.swing.Icon.class
	      		}		    		
		  	),
		  	// setIconTextGap(int)
			super.createMethodDescriptor(getBeanClass(),"setIconTextGap", 
				new Object[] {
	   			DISPLAYNAME, "setIconTextGap(int)",
	      		// SHORTDESCRIPTION, "Set to space between icon and text",
	      		EXPERT, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("gap", new Object[] {
	   					DISPLAYNAME, "iconTextGap",
	      				// SHORTDESCRIPTION, "Space in pixels",
	      				})
	      		},
	      		new Class[] {
	      			int.class
	      		}		    		
		  	),
		  	// setLabelFor(Component)
			super.createMethodDescriptor(getBeanClass(),"setLabelFor", 
				new Object[] {
	   			DISPLAYNAME, "setLabelFor(Component)",
	      		SHORTDESCRIPTION, "Set the component associated with label mnemonic",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("component", new Object[] {
	   					DISPLAYNAME, "aComponent",
	      				// SHORTDESCRIPTION, "Component for mnemonic on label",
	      				})
	      		},
	      		new Class[] {
	      			java.awt.Component.class
	      		}		    		
		  	),
		  	// setText(String)
			super.createMethodDescriptor(getBeanClass(),"setText", 
				new Object[] {
	   			DISPLAYNAME, "setText(String)",
	      		// SHORTDESCRIPTION, "Set the text",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("text", new Object[] {
	   					DISPLAYNAME, "text",
	      				// SHORTDESCRIPTION, "Text",
	      				})
	      		},
	      		new Class[] {
	      			String.class
	      		}		    		
		  	),
		  	// setUI(LabelUI)
			super.createMethodDescriptor(getBeanClass(),"setUI", 
				new Object[] {
	   			DISPLAYNAME, "setUI(LabelUI)",
	      		// SHORTDESCRIPTION, "Set the Label UI",
	      		EXPERT, Boolean.TRUE,
	      		OBSCURE, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("ui", new Object[] {
	   					DISPLAYNAME, "anUI",
	      				// SHORTDESCRIPTION, "Button UI",
	      				}
	      			)
	      		},
	      		new Class[] {
	      			javax.swing.plaf.LabelUI.class
	      		}		    		
		  	),
		  	// setVerticalAlignment(int)
			super.createMethodDescriptor(getBeanClass(),"setVerticalAlignment", 
				new Object[] {
	   			DISPLAYNAME, "setVerticalAlignment(int)",
	      		SHORTDESCRIPTION, "Set the vertical alignment of icon and text",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("alignment", new Object[] {
	   					DISPLAYNAME, "alignment",
	      				// SHORTDESCRIPTION, "CENTER, LEFT or RIGHT",
	      				})
	      		},
	      		new Class[] {
	      			int.class
	      		}		    		
		  	),
		  	// setVerticalTextPosition(int)
			super.createMethodDescriptor(getBeanClass(),"setVerticalTextPosition", 
				new Object[] {
	   			DISPLAYNAME, "setVerticalTextPosition(int)",
	      		SHORTDESCRIPTION, "Set the vertical text position relative to the icon",
	    		}, 
	    		new ParameterDescriptor[] {
	    			createParameterDescriptor("position", new Object[] {
	   					DISPLAYNAME, "textPosition",
	      				// SHORTDESCRIPTION, "CENTER, LEFT or RIGHT",
	      				})
	      		},
	      		new Class[] {
	      			int.class
	      		}		    		
		  	),
		  	// updateUI()
			super.createMethodDescriptor(getBeanClass(),"updateUI", 
				new Object[] {
	   			DISPLAYNAME, "updateUI()",
	      		// SHORTDESCRIPTION, "update the UI",
	      		EXPERT, Boolean.TRUE,
	      		OBSCURE, Boolean.TRUE
	    		}, 
	    		new ParameterDescriptor[] {},
	      		new Class[] {}		    		
		  	)
		};
		return aDescriptorList;
	} catch (Throwable exception) {
		handleException(exception);
	};
	return null;
}
/**
 * Return the property descriptors for this bean.
 * @return java.beans.PropertyDescriptor[]
 */
public java.beans.PropertyDescriptor[] getPropertyDescriptors() {
	try {
		PropertyDescriptor aDescriptorList[] = {
	    	// disabledIcon
			super.createPropertyDescriptor(getBeanClass(),"disabledIcon", new Object[] {
	      	// SHORTDESCRIPTION, "Icon for the disabled label",
	      	BOUND, Boolean.TRUE
	    		}
	    	),
	    	// displayedMnemonic
			super.createPropertyDescriptor(getBeanClass(),"displayedMnemonic", new Object[] {
	      	SHORTDESCRIPTION, "Mnemonic for nearby component",
	      	BOUND, Boolean.TRUE,
	    		}
	    	),
	    	// font
			super.createPropertyDescriptor(getBeanClass(),"font", new Object[] {
	      	// SHORTDESCRIPTION, "Font to use for the text",
	    		}
	    	),
	    	// horizontalAlignment
			super.createPropertyDescriptor(getBeanClass(),"horizontalAlignment", new Object[] {
	      	SHORTDESCRIPTION, "Horizontal alignment of icon and text in button",
	      	BOUND, Boolean.TRUE,
	      	ENUMERATIONVALUES, new Object[] {
	      			"LEFT", new Integer(javax.swing.SwingConstants.LEFT),
	      				"javax.swing.SwingConstants.LEFT",
	      			"CENTER", new Integer(javax.swing.SwingConstants.CENTER),
	      				"javax.swing.SwingConstants.CENTER",
	      			"RIGHT", new Integer(javax.swing.SwingConstants.RIGHT),
	      				"javax.swing.SwingConstants.RIGHT"	      			
	    		}
	    	}
	    	),
	    	// horizontalTextPosition
			super.createPropertyDescriptor(getBeanClass(),"horizontalTextPosition", new Object[] {
	      	SHORTDESCRIPTION, "Horizontal position of text relative to the icon",
	      	ENUMERATIONVALUES, new Object[] {
	      			"LEFT", new Integer(javax.swing.SwingConstants.LEFT),
	      				"javax.swing.SwingConstants.LEFT",
	      			"CENTER", new Integer(javax.swing.SwingConstants.CENTER),
	      				"javax.swing.SwingConstants.CENTER",
	      			"RIGHT", new Integer(javax.swing.SwingConstants.RIGHT),
	      				"javax.swing.SwingConstants.RIGHT"	      			
	    		}
	    		}
	    	),
	    	// icon
			super.createPropertyDescriptor(getBeanClass(),"icon", new Object[] {
	      	// SHORTDESCRIPTION, "Default icon",
	      	BOUND, Boolean.TRUE,
	    		}
	    	),
	    	// iconTextGap
			super.createPropertyDescriptor(getBeanClass(),"iconTextGap", new Object[] {
	      	// SHORTDESCRIPTION, "Space between icon and text in pixels",
	      	BOUND, Boolean.TRUE,
	      	EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// labelFor
			super.createPropertyDescriptor(getBeanClass(),"labelFor", new Object[] {
	      	// SHORTDESCRIPTION, "Component associated with this label",
	      	BOUND, Boolean.TRUE,
	      	EXPERT, Boolean.TRUE
	    		}
	    	),
	    	// text
			super.createPropertyDescriptor(getBeanClass(),"text", new Object[] {
	      	SHORTDESCRIPTION, "Text displayed on the label",
	      	BOUND, Boolean.TRUE,
	      	PREFERRED, Boolean.TRUE	      	
	    		}
	    	),
	    	// verticalAlignment
			super.createPropertyDescriptor(getBeanClass(),"verticalAlignment", new Object[] {
	      	SHORTDESCRIPTION, "Vertical alignment of icon and text in button",
	      	BOUND, Boolean.TRUE,
	      	ENUMERATIONVALUES, new Object[] {
	      			"TOP", new Integer(javax.swing.SwingConstants.TOP),
	      				"javax.swing.SwingConstants.TOP",
	      			"CENTER", new Integer(javax.swing.SwingConstants.CENTER),
	      				"javax.swing.SwingConstants.CENTER",
	      			"BOTTOM", new Integer(javax.swing.SwingConstants.BOTTOM),
	      				"javax.swing.SwingConstants.BOTTOM"	      			
	    		}
	      	
	    		}
	    	),
	    	// verticalTextPosition
			super.createPropertyDescriptor(getBeanClass(),"verticalTextPosition", new Object[] {
	      	SHORTDESCRIPTION, "Vertical position of text relative to the icon",
	      	ENUMERATIONVALUES, new Object[] {
	      			"TOP", new Integer(javax.swing.SwingConstants.TOP),
	      				"javax.swing.SwingConstants.TOP",
	      			"CENTER", new Integer(javax.swing.SwingConstants.CENTER),
	      				"javax.swing.SwingConstants.CENTER",
	      			"BOTTOM", new Integer(javax.swing.SwingConstants.BOTTOM),
	      				"javax.swing.SwingConstants.BOTTOM"	      			
	    		}
	    		}
	    	)		
		};
		return aDescriptorList;
	} catch (Throwable exception) {
		handleException(exception);
	};
	return null;
}
}
